/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.ConfigData;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public abstract class DefaultWindow
extends JFrame
implements FocusListener {
    private static final long serialVersionUID = -5222080706505425996L;

    public DefaultWindow() throws HeadlessException {
        this.init_vars(ConfigData.sWindowWidth, ConfigData.sWindowHeight);
    }

    public DefaultWindow(int n, int n2) throws HeadlessException {
        this.init_vars(n, n2);
    }

    public abstract boolean validateData();

    public void focusGained(FocusEvent focusEvent) {
        String string = focusEvent.getSource().getClass().getName();
        if (string.equalsIgnoreCase("javax.swing.JTextField") || string.equalsIgnoreCase("javax.swing.JPasswordField")) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            jTextField.selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        String string = focusEvent.getSource().getClass().getName();
        if (string.equalsIgnoreCase("javax.swing.JTextField") || string.equalsIgnoreCase("javax.swing.JPasswordField")) {
            JTextField jTextField = (JTextField)focusEvent.getSource();
            jTextField.select(0, 0);
        }
    }

    public void centerScreen() {
        this.setLocationRelativeTo(null);
    }

    private void init_vars(int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        this.getContentPane().invalidate();
        this.getContentPane().removeAll();
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.setSize(dimension);
        this.setPreferredSize(dimension);
    }

    class DateVerifier
    extends InputVerifier {
        private String aDateFormat;

        public DateVerifier(String string) {
            this.aDateFormat = new String(string);
        }

        public boolean verify(JComponent jComponent) {
            boolean bl = false;
            JTextField jTextField = (JTextField)jComponent;
            if (jTextField.getText().matches(this.aDateFormat)) {
                bl = true;
            } else {
                String string = "";
                if (this.aDateFormat.equals("\\d{8}")) {
                    string = "Date format must be yyyyMMdd (e.g. 20070102)";
                } else if (this.aDateFormat.equals("^\\d{2}[/]\\d{2}[/]\\d{4}")) {
                    string = "Date format must be MM/dd/yyyy (e.g. 01/02/2007)";
                }
                JOptionPane.showMessageDialog(null, string, "Invalid Date Entered", 0);
            }
            return bl;
        }
    }

    class TextKeyListener
    implements KeyListener {
        private Action aAction;
        private String aCommand;

        public TextKeyListener(Action action, String string) {
            this.aAction = action;
            this.aCommand = string;
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                ActionEvent actionEvent = new ActionEvent(this, 1001, this.aCommand);
                this.aAction.setEnabled(true);
                this.aAction.actionPerformed(actionEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    public class AutomaticActionEvent
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private ActionListener aListener;

        public AutomaticActionEvent(ActionListener actionListener) {
            this.aListener = actionListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.putValue("ActionCommandKey", actionEvent.getActionCommand());
            this.aListener.actionPerformed(actionEvent);
        }
    }
}

